/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskApplyButtonPanel;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContentListener;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyChangedListener;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTablePanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.toolkit.utils.VWSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class VWTaskContentViewPane
extends JPanel
implements VWTaskPropertyChangedListener {
    private VWTaskBaseNode m_taskNode = null;
    private JPanel m_propPanel = null;
    private VWTaskPropertyPanel m_taskPanel = null;
    private VWTaskTablePanel m_tablePanel = null;
    private VWSplitPane m_viewSplitPane = null;
    private VWTaskApplyButtonPanel m_buttonPanel = null;
    private VWTaskContentListener m_contentListener = null;
    private ActionListener m_actionListener = null;
    private double m_dividerLocation = 0.25;

    public VWTaskContentViewPane(VWTaskBaseNode taskNode, VWTaskPropertyPanel propertyView, VWTaskTablePanel tableView) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_taskNode = taskNode;
        this.setPropertyPanel(propertyView, false, true, false);
        this.setTablePanel(tableView, false);
        this.refreshContent();
    }

    public void setPropertyPanel(VWTaskPropertyPanel taskPanel) {
        this.setPropertyPanel(taskPanel, true, true, false);
    }

    public void setPropertyPanel(VWTaskPropertyPanel taskPanel, boolean buttonPanel, boolean autoStartConfigurable) {
        this.setPropertyPanel(taskPanel, true, buttonPanel, autoStartConfigurable);
    }

    public VWTaskPropertyPanel getPropertyPanel() {
        return this.m_taskPanel;
    }

    public VWTaskApplyButtonPanel getButtonPanel() {
        return this.m_buttonPanel;
    }

    public void setTablePanel(VWTaskTablePanel tableView) {
        VWTaskUtil.updateComponentOrientation(tableView);
        this.setTablePanel(tableView, true);
    }

    public VWTaskTablePanel getTablePanel() {
        return this.m_tablePanel;
    }

    public void setDividerLocation(double location) {
        this.m_dividerLocation = location;
        this.refreshContent();
    }

    protected void setContentListener(VWTaskContentListener listener) {
        this.m_contentListener = listener;
        if (this.m_tablePanel != null) {
            this.m_tablePanel.setContentListener(listener);
        }
    }

    protected void setActionListener(ActionListener listener) {
        this.m_actionListener = listener;
        if (this.m_tablePanel != null) {
            this.m_tablePanel.setActionListener(listener);
        }
    }

    protected void clearTableSelection() {
        if (this.m_tablePanel != null) {
            this.m_tablePanel.clearSelection();
        }
    }

    protected void refreshButtonPanel() {
        if (this.m_buttonPanel != null) {
            this.m_buttonPanel.updateAutostartText(this.m_taskNode);
        }
    }

    public void setDirty() {
        this.m_buttonPanel.setDirty();
        this.m_taskNode.setDirty();
    }

    public void taskPropertyChanged(VWTaskPropertyChangedEvent evt) {
        if (this.m_buttonPanel != null) {
            if (evt.propertiesApplied()) {
                this.m_buttonPanel.clearDirty();
                this.m_taskNode.clearDirty();
                if (this.m_buttonPanel.isAutoStartConfigurable()) {
                    this.m_taskNode.setAutoStartEnabled(this.m_buttonPanel.isAutoStartSelected());
                }
                this.m_taskNode.nodeChanged();
            } else if (evt.propertiesReset()) {
                if (this.m_buttonPanel.isAutoStartConfigurable()) {
                    this.m_buttonPanel.setAutoStartSelected(this.m_taskNode.getAutoStartEnabled());
                }
                this.m_buttonPanel.clearDirty();
                this.m_taskNode.clearDirty();
            } else {
                this.setDirty();
            }
        }
    }

    private void setPropertyPanel(VWTaskPropertyPanel taskPanel, boolean refreshContent, boolean buttonPanel, boolean autoStartConfigurable) {
        this.m_taskPanel = taskPanel;
        if (taskPanel != null) {
            this.m_propPanel = new JPanel(new BorderLayout());
            this.m_taskPanel.addVWTaskPropertyChangedListener(this);
            this.m_propPanel.add((Component)this.m_taskPanel, "Center");
            if (buttonPanel) {
                this.m_buttonPanel = new VWTaskApplyButtonPanel(this, autoStartConfigurable, this.m_taskNode);
                this.m_buttonPanel.addActionListener(this.m_taskPanel);
                this.m_propPanel.add((Component)this.m_buttonPanel, "Last");
            }
        } else {
            this.m_propPanel = null;
        }
        if (refreshContent) {
            this.refreshContent();
        }
    }

    private void setTablePanel(VWTaskTablePanel tableView, boolean refreshContent) {
        if (tableView != null) {
            this.m_tablePanel = tableView;
            this.m_tablePanel.setContentListener(this.m_contentListener);
            this.m_tablePanel.setActionListener(this.m_actionListener);
        } else {
            this.m_tablePanel = null;
        }
        if (refreshContent) {
            this.refreshContent();
        }
    }

    private void refreshContent() {
        this.removeAll();
        if (this.m_tablePanel != null && this.m_propPanel != null) {
            this.m_viewSplitPane = new VWSplitPane(0, this.m_tablePanel, this.m_propPanel);
            this.m_viewSplitPane.setOneTouchExpandable(true);
            this.m_viewSplitPane.setDividerSize(8);
            this.m_viewSplitPane.setDividerLocation(this.m_dividerLocation);
            this.add((Component)this.m_viewSplitPane, "Center");
        } else if (this.m_propPanel != null) {
            this.add((Component)this.m_propPanel, "Center");
        } else if (this.m_tablePanel != null) {
            this.add(new JPanel().add(this.m_tablePanel), "Center");
        }
        this.revalidate();
        this.repaint();
    }

    protected VWTaskBaseNode getNode() {
        return this.m_taskNode;
    }
}

